T_environment = 32;

simlog_reactive = simlog_ElectricVehicleThermalManagement;
chiller_reactive.efficiency.effCoeff = Efficiency_chiller;
condenser_reactive.efficiency.effCoeff = Efficiency_condenser;
chiller_reactive.TwoP.h.in = h_chiller_2P_in;
chiller_reactive.TwoP.h.out =  h_chiller_2P_out;
chiller_reactive.TL.h.in = h_chiller_TL_in;
chiller_reactive.TL.h.out = h_chiller_TL_out;
compressor_reactive.fluid.h.in = h_comp_in;
compressor_reactive.fluid.h.out = h_comp_out;
condenser_reactive.TwoP.h.in = h_cond_2P_in;
condenser_reactive.TwoP.h.out = h_cond_2P_out;
battery_reactive.Q_joule = Q_joule;
battery_reactive.T = T_battery;
battery_reactive.i.tot = i_battery;
battery_reactive.i.BMS = i_BMS;
chiller_reactive.TwoP.mdot = mdot_chiller_2P_out;
chiller_reactive.TL.mdot.in = mdot_chiller_TL_in;
chiller_reactive.TL.mdot.out = mdot_chiller_TL_out;
chillerByPassValve_reactive.mdot.in = mdot_ChillerByPassValve_in;
chillerByPassValve_reactive.mdot.outB = mdot_ChillerByPassValve_outB;
chillerByPassValve_reactive.mdot.outC = mdot_ChillerByPassValve_outC;
compressor_reactive.fluid.mdot.in = mdot_comp_in;
compressor_reactive.fluid.mdot.out = mdot_comp_out;
condenser_reactive.TwoP.mdot.out = mdot_cond_2P_out;
condenser_reactive.TwoP.mdot.in = mdot_cond_in;
battery_reactive.coolant.SC3.mdot = mdot_coolant_battery_in;
battery_reactive.coolant.SC4.mdot = mdot_coolant_battery_out;
chiller_reactive.TwoP.p.in = p_chiller_2P_in;
chiller_reactive.TwoP.p.out = p_chiller_2P_out;
chiller_reactive.TL.p.in = p_chiller_TL_in;
chiller_reactive.TL.p.out = p_chiller_TL_out;
chillerByPassValve_reactive.p.in = p_ChillerByPassValve_in;
chillerByPassValve_reactive.p.outB = p_ChillerByPassValve_outB;
chillerByPassValve_reactive.p.outC = p_ChillerByPassValve_outC;
compressor_reactive.fluid.p.in = p_comp_in;
compressor_reactive.fluid.p.out = p_comp_out;
condenser_reactive.TwoP.p.in = p_cond_2P_in;
condenser_reactive.TwoP.p.out = p_cond_2P_out;
battery_reactive.coolant.SC3.p = p_coolant_battery_in;
battery_reactive.coolant.SC4.p = p_coolant_battery_out;
battery_reactive.coolant.SC3.Phi = Phi_battery_in;
battery_reactive.coolant.SC4.Phi = Phi_battery_out;
chiller_reactive.TwoP.Phi.in = Phi_chiller_2P_in;
chiller_reactive.TwoP.Phi.out = Phi_chiller_out;
chiller_reactive.TL.Phi.in = Phi_chiller_TL_in;
chiller_reactive.TL.Phi.out = Phi_chiller_TL_out;
chillerByPassValve_reactive.Phi.in = Phi_ChillerByPassValve_in;
chillerByPassValve_reactive.Phi.outB = Phi_ChillerByPassValve_outB;
chillerByPassValve_reactive.Phi.outC = Phi_ChillerByPassValve_outC;
compressor_reactive.fluid.Phi.in = Phi_comp_in;
compressor_reactive.fluid.Phi.out = Phi_comp_out;
condenser_reactive.TwoP.Phi.in = Phi_cond_in;
condenser_reactive.TwoP.Phi.out = Phi_cond_out;
chiller_reactive.TL.rho.in = rho_chiller_TL_in;
chiller_reactive.TL.rho.out = rho_chiller_TL_out;
chillerByPassValve_reactive.rho.in = rho_ChillerByPassValve_in;
chillerByPassValve_reactive.rho.outB = rho_ChillerByPassValve_outB;
chillerByPassValve_reactive.rho.outC = rho_ChillerByPassValve_outC;
battery_reactive.coolant.SC3.rho = rho_coolant_battery_in;
battery_reactive.coolant.SC4.rho = rho_coolant_battery_out;
chiller_reactive.TwoP.T.in = T_chiller_2P_in;
chiller_reactive.TwoP.T.out = T_chiller_2P_out;
chiller_reactive.TL.T.in = T_chiller_TL_in;
chiller_reactive.TL.T.out = T_chiller_TL_out;
chillerByPassValve_reactive.T.in = T_ChillerByPassValve_in;
chillerByPassValve_reactive.T.outB = T_ChillerByPassValve_outB;
chillerByPassValve_reactive.T.outC = T_ChillerByPassValve_outC;
compressor_reactive.fluid.T.in = T_comp_in;
compressor_reactive.fluid.T.out = T_comp_out;
condenser_reactive.TwoP.T.in = T_cond_2P_in;
condenser_reactive.TwoP.T.out = T_cond_2P_out;
battery_reactive.coolant.SC3.T = T_coolant_battery_in;
battery_reactive.coolant.SC4.T = T_coolant_battery_out;
chiller_reactive.TwoP.u.in = u_chiller_2P_in;
chiller_reactive.TwoP.u.out = u_chiller_2P_out;
chiller_reactive.TL.u.in = u_chiller_TL_in;
chiller_reactive.TL.u.out = u_chiller_TL_out;
chillerByPassValve_reactive.u.in = u_ChillerByPassValve_in;
chillerByPassValve_reactive.u.outB = u_ChillerByPassValve_outB;
chillerByPassValve_reactive.u.outC = u_ChillerByPassValve_outC;
compressor_reactive.fluid.u.in = u_comp_in;
compressor_reactive.fluid.u.out = u_comp_out;
condenser_reactive.TwoP.u.in = u_cond_2P_in;
condenser_reactive.TwoP.u.out = u_cond_2P_out;
battery_reactive.coolant.SC3.u = u_coolant_battery_in;
battery_reactive.coolant.SC4.u = u_coolant_battery_out;
chiller_reactive.TwoP.v.in = v_chiller_2P_in;
chiller_reactive.TwoP.v.out = v_chiller_2P_out;
compressor_reactive.fluid.v.in = v_comp_in;
compressor_reactive.fluid.v.out = v_comp_out;
condenser_reactive.TwoP.v.in = v_cond_2P_in;
condenser_reactive.TwoP.v.out = v_cond_2P_out;
compressor_reactive.fluid.vL.in = vL_comp_in;
compressor_reactive.fluid.vL.out = vL_comp_out;
compressor_reactive.fluid.vV.in = vV_comp_in;
compressor_reactive.fluid.vV.out = vV_comp_out;
chiller_reactive.TwoP.x.in = x_chiller_2P_in;
chiller_reactive.TwoP.x.out = x_chiller_2P_out;
compressor_reactive.fluid.x.in = x_comp_in;
compressor_reactive.fluid.x.out = x_comp_out;
condenser_reactive.TwoP.x.out = x_cond_2P_out;
condenser_reactive.TwoP.x.in = x_cond_2P_in;
battery_reactive.T = T_battery;
condenser_reactive.efficiency.h_infinite = h_infiniteCond;
chiller_reactive.efficiency.h_infinite = h_infiniteChiller;
EPowerBMS_reactive.compressor = EPower_Compressor;
EPowerBMS_reactive.fan = EPower_Fan;
EPowerBMS_reactive.motorPump = EPower_MotorPump;
EPowerBMS_reactive.batteryPump = EPower_BatteryPump;

eta_Vnominal = 0.9;
gamma = 1.13;
p_in_nom = 0.3; %MPa
beta_nom = 4.6;
vr_nominal = ((beta_nom*p_in_nom)/(p_in_nom))^(1/gamma);
C = (1-eta_Vnominal)/(vr_nominal-1);
VolumetricEfficiency.time = compressor_reactive.fluid.v.out.time;
VolumetricEfficiency.values = zeros(length(compressor_reactive.fluid.v.out.time),1);
for t = 1:1:length(compressor_reactive.fluid.v.out.time)
    VolumetricEfficiency.values(t) = 1 + C -C*(compressor_reactive.fluid.v.in.signals.values(t)/compressor_reactive.fluid.v.out.signals.values(t));
end

compressor_reactive.VolumetricEfficiency = VolumetricEfficiency;

if T_environment == 32
    simlog_reactive_Tenv32 = simlog_reactive;
    EPowerBTM_reactive_Tenv32 = EPowerBMS_reactive;
    chiller_reactive_Tenv32 = chiller_reactive;
    chillerByPassValve_reactive_Tenv32 = chillerByPassValve_reactive;
    compressor_reactive_Tenv32 = compressor_reactive;
    condenser_reactive_Tenv32 = condenser_reactive;
    battery_reactive_Tenv32 = battery_reactive;

    save simlog_reactive_Tenv32 EPowerBTM_reactive_Tenv32 simlog_reactive_Tenv32 chiller_reactive_Tenv32 chillerByPassValve_reactive_Tenv32 compressor_reactive_Tenv32 condenser_reactive_Tenv32 battery_reactive_Tenv32 
end


if T_environment == 25
    simlog_reactive_Tenv25 = simlog_reactive;
    EPowerBTM_reactive_Tenv25 = EPowerBMS_reactive;
    chiller_reactive_Tenv25 = chiller_reactive;
    chillerByPassValve_reactive_Tenv25 = chillerByPassValve_reactive;
    compressor_reactive_Tenv25 = compressor_reactive;
    condenser_reactive_Tenv25 = condenser_reactive;
    battery_reactive_Tenv25 = battery_reactive;

    save simlog_reactive_Tenv25 EPowerBTM_reactive_Tenv25 simlog_reactive_Tenv25 chiller_reactive_Tenv25 chillerByPassValve_reactive_Tenv25 compressor_reactive_Tenv25 condenser_reactive_Tenv25 battery_reactive_Tenv25 
end


if T_environment == 20
    simlog_reactive_Tenv20 = simlog_reactive;
    EPowerBTM_reactive_Tenv20 = EPowerBMS_reactive;
    chiller_reactive_Tenv20 = chiller_reactive;
    chillerByPassValve_reactive_Tenv20 = chillerByPassValve_reactive;
    compressor_reactive_Tenv20 = compressor_reactive;
    condenser_reactive_Tenv20 = condenser_reactive;
    battery_reactive_Tenv20 = battery_reactive;

    save simlog_reactive_Tenv20 EPowerBTM_reactive_Tenv20 simlog_reactive_Tenv20 chiller_reactive_Tenv20 chillerByPassValve_reactive_Tenv20 compressor_reactive_Tenv20 condenser_reactive_Tenv20 battery_reactive_Tenv20 
end




















